#include <stdio.h>
#include <stdlib.h>


#include "audiomain.h"
#include "AudioC.h"
#include "reverb_wave.h"

AudioC *Wav,*newwave;

void cleanup(long exitcode)
{
  if (Wav!=NULL) delete Wav;
  if (newwave!=NULL) delete newwave;

  exit(exitcode);
}

int main(int argc, char *argv[])
{
long retval;

// verify we have all the arguments
if (argc!=5)
{
   printf("Usage:\n %s input_file.wav output_file.wav delay(ms) amplitude(%)\n",argv[0]);
   cleanup(-1);
}

// attempt to create a wave object
Wav=new AudioC(argv[1]);
if (Wav==NULL)
{
   printf("Could not create audio object.  Could not read file or insufficent memory.\n");
   cleanup(-2);
}

// copy existing wave object to a new one
newwave= new AudioC(*Wav);
if (newwave==NULL)
{
   printf("Could not copy audio object.  May be insufficient memory.\n");
   cleanup(-3);
}

// do the reverb
retval=reverb_wav(*Wav,atof(argv[3]),atof(argv[4]),*newwave);
if (retval==0)
{
   printf("Reverb Wave failed, probably insufficient memory.\n");
   cleanup(-4);
}

// save the new wave
retval=newwave->WriteFile(argv[2]);
if (retval==0)
{
   printf("Could not save .wav file.\n");
   cleanup(-5);
}

// cleanup

}
//---------------------------------------------------------------------------
